/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.ftp.dialogs;

import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.ftp.FTPUIPlugin;
import com.aptana.ui.ftp.dialogs.Messages;
import com.aptana.ui.ftp.internal.FTPConnectionPropertyComposite;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FTPConnectionPointPropertyDialog
extends TitleAreaDialog
implements IPropertyDialog,
FTPConnectionPropertyComposite.IListener {
    private Image titleImage;
    private FTPConnectionPropertyComposite ftpComposite;
    private IBaseRemoteConnectionPoint ftpConnectionPoint;
    private boolean lockedUI;

    public FTPConnectionPointPropertyDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    public boolean isResizable() {
        return true;
    }

    public void setPropertySource(Object element) {
        this.ftpConnectionPoint = null;
        if (element instanceof IBaseRemoteConnectionPoint) {
            this.ftpConnectionPoint = (IBaseRemoteConnectionPoint)element;
        }
        if (this.ftpComposite != null) {
            this.ftpComposite.setConnectionPoint(this.ftpConnectionPoint);
        }
    }

    public Object getPropertySource() {
        return this.ftpConnectionPoint;
    }

    protected ConnectionPointType getConnectionPointType() {
        if (this.ftpConnectionPoint != null) {
            return CoreIOPlugin.getConnectionPointManager().getType((IConnectionPoint)this.ftpConnectionPoint);
        }
        return CoreIOPlugin.getConnectionPointManager().getType("ftp");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.titleImage = FTPUIPlugin.getImageDescriptor("/icons/full/wizban/ftp.png").createImage();
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FTPConnectionPointPropertyDialog.this.dispose();
            }
        });
        this.setTitleImage(this.titleImage);
        if (this.ftpConnectionPoint != null) {
            this.setTitle(MessageFormat.format(Messages.FTPConnectionPointPropertyDialog_MessageTitle_Edit, this.getConnectionPointType().getName()));
            this.getShell().setText(Messages.FTPConnectionPointPropertyDialog_Title_Edit);
        } else {
            this.setTitle(MessageFormat.format(Messages.FTPConnectionPointPropertyDialog_MessageTitle_New, this.getConnectionPointType().getName()));
            this.getShell().setText(Messages.FTPConnectionPointPropertyDialog_Title_New);
        }
        this.ftpComposite = this.createConnectionComposite(dialogArea, this.ftpConnectionPoint);
        this.ftpComposite.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        return dialogArea;
    }

    protected FTPConnectionPropertyComposite createConnectionComposite(Composite parent, IBaseRemoteConnectionPoint connectionPoint) {
        return new FTPConnectionPropertyComposite(parent, 0, connectionPoint, this);
    }

    protected FTPConnectionPropertyComposite getConnectionComposite() {
        return this.ftpComposite;
    }

    protected void dispose() {
        if (this.titleImage != null) {
            this.setTitleImage(null);
            this.titleImage.dispose();
            this.titleImage = null;
        }
    }

    protected boolean canHandleShellCloseEvent() {
        return !this.lockedUI && super.canHandleShellCloseEvent();
    }

    protected void okPressed() {
        if (!this.ftpComposite.isValid()) {
            return;
        }
        if (this.ftpComposite.completeConnection()) {
            this.ftpConnectionPoint = this.ftpComposite.getConnectionPoint();
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        this.ftpComposite.setCanceled(true);
        if (!this.lockedUI) {
            super.cancelPressed();
        }
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            if (this.ftpComposite != null) {
                this.ftpComposite.validate();
            }
        }
    }

    public void setValid(boolean valid) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(valid);
        }
    }

    public void error(String message) {
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(message);
        }
    }

    public void lockUI(boolean lock) {
        this.lockedUI = lock;
        this.getButton(0).setEnabled(!lock);
    }

    public void layoutShell() {
        Point size = this.getInitialSize();
        Rectangle bounds = this.getConstrainedShellBounds(new Rectangle(0, 0, size.x, size.y));
        this.getShell().setSize(bounds.width, bounds.height);
    }
}

